/*
 * Decompiled with CFR 0.152.
 */
package com.cra.sim.validator.regn.format;

import com.cra.common.reg.util.CRAConfigReader;
import com.cra.framework.reg.vo.SessionVO;
import com.cra.sim.util.SubsRegConst;
import com.cra.sim.util.SubsRegRespGenerator;
import com.cra.sim.util.WriteRecord;
import com.cra.sim.validator.BaseValidator;
import com.cra.sim.vo.SubsRegFileVO;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileHdrFormatValidator
extends BaseValidator {
    SubsRegRespGenerator objRespGen;
    WriteRecord objWRecord;
    SubsRegFileVO objSubsRegFileVo;
    String strFileType;
    String sectorType;

    public FileHdrFormatValidator(SessionVO sessVO) {
        super(sessVO);
        this.objRespGen = new SubsRegRespGenerator(this.sessVO);
        this.objWRecord = new WriteRecord();
        this.objSubsRegFileVo = new SubsRegFileVO();
        this.strFileType = "";
        this.sectorType = null;
    }

    public FileHdrFormatValidator(SessionVO sessVO, String sectorValue) {
        super(sessVO);
        this.objRespGen = new SubsRegRespGenerator(this.sessVO);
        this.objWRecord = new WriteRecord();
        this.objSubsRegFileVo = new SubsRegFileVO();
        this.strFileType = "";
        this.sectorType = null;
        this.sectorType = sectorValue;
        if (this.sectorType.equalsIgnoreCase("U")) {
            this.isUnorganizedSector = true;
        }
    }

    public SubsRegFileVO validateFileHdrFormat(SubsRegConst pcon) {
        boolean boolSuccTemp = true;
        boolean boolErrRec = false;
        this.pcon = pcon;
        try {
            String strLine = pcon.getFileLine();
            String actualLine = pcon.getFileLine();
            this.strFileType = pcon.getFileType();
            String[] arrStr = new String[10];
            int start = 0;
            int end = 0;
            int i = 0;
            int intcaratcnt = 0;
            strLine = strLine.toUpperCase();
            System.out.println(strLine);
            try {
                while ((end = strLine.substring(start).indexOf("^")) >= 0) {
                    ++intcaratcnt;
                    arrStr[i] = strLine.substring(start, start + end);
                    start = start + end + 1;
                    ++i;
                }
                System.out.println("after while intcaratcnt " + intcaratcnt);
                arrStr[i] = strLine.substring(start);
            }
            catch (Exception e) {
                System.out.println(this.sessVO + "Error Carat count is invalid");
                this.objRespGen.genHTML(pcon, "Carat count", "" + intcaratcnt, "101502");
                this.objSubsRegFileVo.setSubsRegFileErrorFlg(true);
                return this.objSubsRegFileVo;
            }
            if (intcaratcnt != 7) {
                this.objRespGen.genHTML(pcon, "Carat count", "" + intcaratcnt, "101502");
                this.objSubsRegFileVo.setSubsRegFileErrorFlg(true);
                return this.objSubsRegFileVo;
            }
            boolSuccTemp = this.valLineNumber(arrStr[0].trim(), "File Header Line Number", 1);
            if (!boolSuccTemp) {
                boolErrRec = true;
            } else {
                this.objSubsRegFileVo.setLineNum(arrStr[0].trim());
            }
            boolSuccTemp = this.valRecordType(arrStr[1].trim(), actualLine);
            if (!boolSuccTemp) {
                boolErrRec = true;
            } else {
                this.objSubsRegFileVo.setFileSectType(arrStr[1].trim());
            }
            boolSuccTemp = this.valFileType(arrStr[2].trim());
            if (!boolSuccTemp) {
                boolErrRec = true;
            } else {
                pcon.setFileType(arrStr[2].trim());
                this.objSubsRegFileVo.setFileType(arrStr[2].trim());
            }
            boolSuccTemp = this.valTransType(arrStr[3].trim());
            System.out.println("transtype: " + arrStr[3].trim());
            if (boolSuccTemp) {
                pcon.setUploadType(arrStr[3].trim());
                this.objSubsRegFileVo.setTransType(arrStr[3].trim());
                if ("M".equalsIgnoreCase(arrStr[3].trim())) {
                    pcon.setUploadType("U");
                    this.objSubsRegFileVo.setTransType("U");
                    this.objSubsRegFileVo.setMinortransTypeFlag(arrStr[3].trim());
                    pcon.setMinortransTypeFlag(arrStr[3].trim());
                    System.out.println("objSubsRegFileVo.getTransType(): " + this.objSubsRegFileVo.getTransType() + " minortype: " + pcon.getMinortransTypeFlag());
                }
                if ("N".equalsIgnoreCase(arrStr[3].trim())) {
                    pcon.setUploadType("U");
                    this.objSubsRegFileVo.setTransType("U");
                    this.objSubsRegFileVo.setTier5transTypeFlag(arrStr[3].trim());
                    pcon.setTier5transTypeFlag(arrStr[3].trim());
                    System.out.println("objSubsRegFileVo.getTransType(): " + this.objSubsRegFileVo.getTransType() + " minortype: " + pcon.getTier5transTypeFlag());
                }
                if ("P".equalsIgnoreCase(arrStr[3].trim())) {
                    pcon.setUploadType("R");
                    this.objSubsRegFileVo.setTransType("R");
                    this.objSubsRegFileVo.setUPStransTypeFlag(arrStr[3].trim());
                    pcon.setUPStransTypeFlag(arrStr[3].trim());
                    System.out.println("objSubsRegFileVo.getTransType(): " + this.objSubsRegFileVo.getTransType() + " minortype: " + pcon.getMinortransTypeFlag());
                }
                if (this.objSubsRegFileVo.getTransType() != null && this.objSubsRegFileVo.getTransType().equalsIgnoreCase("U") && this.objSubsRegFileVo.getTransType().equalsIgnoreCase("M")) {
                    pcon.setFieldNameAckOrRecipt("Receipt No");
                    System.out.println("TransType: " + this.objSubsRegFileVo.getTransType() + " pcon.getUploadType: " + pcon.getUploadType() + " pcon.getFieldNameAckOrRecipt: " + pcon.getFieldNameAckOrRecipt());
                } else {
                    pcon.setFieldNameAckOrRecipt("Ack No");
                }
            } else {
                boolErrRec = true;
            }
            boolSuccTemp = this.valCreatnDate(arrStr[4].trim());
            if (boolSuccTemp) {
                pcon.setCreatnDate(arrStr[4].trim());
                this.objSubsRegFileVo.setDateOfCreation(arrStr[4].trim());
            } else {
                boolErrRec = true;
            }
            boolSuccTemp = this.valFileSeqNum(arrStr[5].trim());
            if (boolSuccTemp) {
                pcon.setFileSeqNum(arrStr[5].trim());
                this.objSubsRegFileVo.setFileSeqNo(Integer.parseInt(arrStr[5].trim()));
            } else {
                boolErrRec = true;
            }
            boolSuccTemp = this.valTotalNumOfPRAN(arrStr[6].trim());
            if (boolSuccTemp) {
                pcon.setBatchCnt(arrStr[6].trim());
                this.objSubsRegFileVo.setNumOfPRANs(Integer.parseInt(arrStr[6].trim()));
            } else {
                boolErrRec = true;
            }
            boolSuccTemp = this.valCRAName(arrStr[7].trim());
            if (boolSuccTemp) {
                if ("NCRA".equalsIgnoreCase(arrStr[7].trim())) {
                    pcon.setCraNameValue(arrStr[7].trim());
                    this.objSubsRegFileVo.setCraNameValue(arrStr[7].trim());
                    this.objSubsRegFileVo.setXname("NCRA");
                } else if ("XCRA".equalsIgnoreCase(arrStr[7].trim())) {
                    System.out.println("inXCRA");
                    pcon.setCraNameValue("XCRA");
                    this.objSubsRegFileVo.setCraNameValue("XCRA");
                    this.objSubsRegFileVo.setXname("XCRA");
                    System.out.println("objSubsRegFileVo.getCraNameValue()::" + this.objSubsRegFileVo.getCraNameValue());
                }
            } else {
                boolErrRec = true;
            }
            if (SubsRegConst.getUtilityLevel() == 1) {
                if (!boolErrRec) {
                    boolSuccTemp = this.addHash(pcon.getFileLine());
                    if (!boolSuccTemp) {
                        this.objSubsRegFileVo.setSubsRegFileErrorFlg(true);
                        return this.objSubsRegFileVo;
                    }
                    if ("XCRA".equalsIgnoreCase(arrStr[7].trim())) {
                        this.objWRecord.writeRecord(pcon.getFileLine(), pcon.getStrFilePath(), pcon.getStrUploadDirPath());
                    } else {
                        this.objWRecord.writeRecord(pcon.getFileLine(), pcon.getStrFilePath(), pcon.getStrUploadDirPath());
                    }
                    this.objSubsRegFileVo.setSubsRegFileErrorFlg(false);
                    return this.objSubsRegFileVo;
                }
                this.objSubsRegFileVo.setSubsRegFileErrorFlg(true);
                return this.objSubsRegFileVo;
            }
            this.objSubsRegFileVo.setSubsRegFileErrorFlg(!boolSuccTemp);
            return this.objSubsRegFileVo;
        }
        catch (Exception e) {
            this.objSubsRegFileVo.setSubsRegFileErrorFlg(true);
            return this.objSubsRegFileVo;
        }
    }

    private boolean valRecordType(String strField, String actualLine) {
        boolean boolFlag = true;
        try {
            String[] fileFields = actualLine.split("\\^");
            if (fileFields != null && fileFields[1] != null && !fileFields[1].equals("FH") && !fileFields[1].equals("fh")) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "Record Type", fileFields[1], "101021");
            }
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    private boolean valFileType(String strField) {
        boolean boolFlag = true;
        try {
            if (!strField.equals("PRAN") && !strField.equals("PSCH")) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "File Type", strField, "101031");
            }
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    private boolean valTransType(String strField) {
        boolean boolFlag = true;
        try {
            if (!(strField.equals("R") || strField.equalsIgnoreCase("U") || strField.equalsIgnoreCase("M") || strField.equalsIgnoreCase("P") || strField.equalsIgnoreCase("N"))) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "Transaction Type", strField, "101041");
            }
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    private boolean valCreatnDate(String strField) {
        boolean boolFlag = true;
        Date currentDate = new Date();
        Date creationDate = new Date();
        SimpleDateFormat date_formatter = new SimpleDateFormat("MMddyyyy");
        try {
            if (!this.isDate(strField)) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "Date of File Creation", strField, "101051");
                return boolFlag;
            }
            creationDate = date_formatter.parse(strField);
            if (!creationDate.before(currentDate)) {
                this.objRespGen.genHTML(this.pcon, "Date of File Creation", strField, "101052");
                boolFlag = false;
            }
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    private boolean valFileSeqNum(String strField) {
        boolean boolFlag = true;
        try {
            if (strField.length() != 3) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "File Sequence number", strField, "101062");
                return boolFlag;
            }
            if (Integer.parseInt(strField) <= 0) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "File Sequence number", strField, String.valueOf(this.strFileType) + "101063");
                return boolFlag;
            }
        }
        catch (NumberFormatException nfe) {
            boolFlag = false;
            this.objRespGen.genHTML(this.pcon, "File Sequence number", strField, "101061");
            return boolFlag;
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    private boolean valTotalNumOfPRAN(String strField) {
        boolean boolFlag = true;
        try {
            if (strField.length() != 6) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "Total Number of PRANs", strField, "101072");
                return boolFlag;
            }
            int intField = Integer.parseInt(strField);
            if (intField <= 0) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "Total Number of PRANs", strField, "101073");
                return boolFlag;
            }
            if (intField > 9999) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "Total Number of PRANs", strField, "101074");
                return boolFlag;
            }
        }
        catch (NumberFormatException nfe) {
            boolFlag = false;
            this.objRespGen.genHTML(this.pcon, "Total Number of PRANs", strField, "101071");
            this.pcon.setBatchCnt("0");
            return boolFlag;
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    @Override
    public boolean addHash(String strField) {
        boolean boolFlag = true;
        try {
            strField = String.valueOf(strField) + "^" + CRAConfigReader.getConfigVal("CRACENTRAL.FVU.SubsRegFVUVersion") + "^";
            int valHash = 0;
            int i = 1;
            while (i <= strField.length()) {
                valHash += i * strField.charAt(i - 1);
                ++i;
            }
            strField = String.valueOf(strField) + valHash;
            this.pcon.setFileLine(strField);
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    private boolean valCRAName(String strField) {
        boolean boolFlag = true;
        try {
            if (!strField.equalsIgnoreCase("NCRA") && !strField.equalsIgnoreCase("XCRA")) {
                boolFlag = false;
                this.objRespGen.genHTML(this.pcon, "CRA Name", strField, "101081");
            }
        }
        catch (Exception e) {
            boolFlag = false;
            return boolFlag;
        }
        return boolFlag;
    }

    @Override
    public String getErrorForm() {
        String errCode = "101";
        return errCode;
    }
}

